<?php
require_once __DIR__.'/../config/config.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/helpers.php';

guard();
$pdo->beginTransaction();
try{
  $items = [];
  $names = $_POST['item_name'] ?? [];
  $pids  = $_POST['product_id'] ?? [];
  $prices= $_POST['price'] ?? [];
  $qtys  = $_POST['qty'] ?? [];
  $sub=0;
  for($i=0;$i<count($names);$i++){
    $n=trim($names[$i]??''); if($n==='') continue;
    $pid = (int)($pids[$i]??0);
    $price=(float)($prices[$i]??0);
    $qty  =(int)($qtys[$i]??0);
    $line = $price*$qty; $sub+=$line;
    $items[] = ['pid'=>$pid,'name'=>$n,'price'=>$price,'qty'=>$qty,'line'=>$line];
  }
  if(!$items) throw new Exception('No items');
  $gst = (float)($_POST['gst_percent']??0); $grand = round($sub*(1+$gst/100));
  $stmt=$pdo->prepare('INSERT INTO sales(invoice_no,sale_date,customer_id,customer_name,mobile,notes,sub_total,gst_percent,grand_total,user_id) VALUES(?,?,?,?,?,?,?,?,?,?)');
  $invNo='INV-'.str_pad((string)(time()%100000),5,'0',STR_PAD_LEFT);
  $stmt->execute([$invNo, today(), null, trim($_POST['customer_name']??'Walk‑in'), trim($_POST['mobile']??''), trim($_POST['notes']??''), $sub, $gst, $grand, $_SESSION['user']['id']]);
  $saleId = (int)$pdo->lastInsertId();

  $insItem=$pdo->prepare('INSERT INTO sale_items(sale_id,product_id,item_name,price,qty,line_total) VALUES(?,?,?,?,?,?)');
  foreach($items as $it){
    $insItem->execute([$saleId,$it['pid']?:null,$it['name'],$it['price'],$it['qty'],$it['line']]);
    if($it['pid']){ $pdo->prepare('UPDATE products SET stock=stock-? WHERE id=?')->execute([$it['qty'],$it['pid']]); }
  }
  $pdo->commit();
  header('Location: '.BASE_PATH.'/index.php?p=invoices&ok=1');
} catch(Exception $e){ $pdo->rollBack(); die('Error: '.$e->getMessage()); }
