<?php
$prods = $pdo->query('SELECT id, name, price, stock FROM products ORDER BY name')->fetchAll();
?>
<div class="bg-white rounded-xl shadow p-4">
  <div class="flex items-center justify-between mb-3">
    <div class="font-semibold">New Sale</div>
    <button form="saleForm" class="px-3 py-2 rounded text-white" style="background:#0ea5b7">💾 Save</button>
  </div>
  <form id="saleForm" method="post" action="<?=BASE_PATH?>/pages/sale_save.php">
    <div class="grid md:grid-cols-3 gap-3">
      <div><label class="text-sm">Customer</label><input name="customer_name" class="border rounded w-full p-2" placeholder="Walk‑in"></div>
      <div><label class="text-sm">Mobile</label><input name="mobile" class="border rounded w-full p-2"></div>
      <div><label class="text-sm">Notes</label><input name="notes" class="border rounded w-full p-2"></div>
    </div>
    <div class="mt-4 overflow-x-auto">
      <table class="w-full text-sm" id="tbl">
        <thead><tr class="text-left text-gray-500"><th class="p-2">Product</th><th class="p-2">Price</th><th class="p-2">Qty</th><th class="p-2">Total</th><th class="p-2"></th></tr></thead>
        <tbody id="rows"></tbody>
      </table>
      <button type="button" onclick="addRow()" class="px-3 py-1 border rounded mt-2">＋ Add Item</button>
    </div>
    <div class="mt-4 flex justify-end gap-6 text-lg">
      <div>Sub‑total: <b id="sub">0</b></div>
      <div>GST %: <input name="gst_percent" id="gst" type="number" class="w-20 border rounded p-1" value="0"></div>
      <div>Grand: <b id="grand">0</b></div>
    </div>
  </form>
</div>
<script>
const prods = <?=json_encode($prods)?>;
function addRow(){
  const tr=document.createElement('tr');
  tr.innerHTML=`<td class="p-1">
    <select name="item_name[]" class="border rounded p-1 w-full" onchange="syncPrice(this)">
      <option value="">-- choose --</option>
      ${prods.map(p=>`<option data-price="${p.price}" data-id="${p.id}" value="${p.name}">${p.name} (Stock: ${p.stock})</option>`).join('')}
    </select>
    <input type="hidden" name="product_id[]" value="">
  </td>
  <td class="p-1"><input name="price[]" type="number" step="0.01" class="border rounded p-1 w-24" value="0" oninput="recalc()"></td>
  <td class="p-1"><input name="qty[]" type="number" class="border rounded p-1 w-20" value="1" oninput="recalc()"></td>
  <td class="p-1 text-right"><span class="line">0</span></td>
  <td class="p-1"><button type="button" class="px-2 py-1 border rounded" onclick="this.closest('tr').remove(); recalc();">✖</button></td>`;
  document.getElementById('rows').appendChild(tr);
}
function syncPrice(sel){
  const opt=sel.options[sel.selectedIndex];
  const price=+opt.getAttribute('data-price')||0; sel.closest('tr').querySelector('[name="price[]"]').value=price;
  sel.closest('tr').querySelector('[name="product_id[]"]').value=opt.getAttribute('data-id')||'';
  recalc();
}
function recalc(){
  let sub=0; document.querySelectorAll('#rows tr').forEach(tr=>{
    const price=+tr.querySelector('[name="price[]"]').value||0; const qty=+tr.querySelector('[name="qty[]"]').value||0; const line=price*qty; sub+=line; tr.querySelector('.line').textContent=Math.round(line);
  });
  const gst=+document.getElementById('gst').value||0; const grand=Math.round(sub*(1+gst/100));
  document.getElementById('sub').textContent=Math.round(sub); document.getElementById('grand').textContent=grand;
}
addRow();
</script>
