<?php $prods = $pdo->query('SELECT id, name, price, stock FROM products ORDER BY name')->fetchAll(); ?>
<div class="bg-white rounded-xl shadow p-4">
  <div class="flex items-center justify-between mb-3">
    <div class="font-semibold">New Purchase</div>
    <button form="pForm" class="px-3 py-2 rounded text-white" style="background:#0ea5b7">💾 Save</button>
  </div>
  <form id="pForm" method="post" action="#" onsubmit="alert('Implement purchase_save similar to sale_save (stock +)!');return false;">
    <div class="grid md:grid-cols-4 gap-3">
      <div><label class="text-sm">Supplier</label><input name="supplier_name" class="border rounded w-full p-2"></div>
      <div><label class="text-sm">Mobile</label><input name="mobile" class="border rounded w-full p-2"></div>
      <div><label class="text-sm">Notes</label><input name="notes" class="border rounded w-full p-2"></div>
      <div><label class="text-sm">Date</label><input name="purch_date" type="date" class="border rounded w-full p-2" value="<?=date('Y-m-d')?>"></div>
    </div>
    <div class="mt-4">
      <table class="w-full text-sm" id="tbl2">
        <thead><tr class="text-left text-gray-500"><th class="p-2">Product</th><th class="p-2">Cost</th><th class="p-2">Qty</th><th class="p-2">Total</th><th class="p-2"></th></tr></thead>
        <tbody id="rows2"></tbody>
      </table>
      <button type="button" onclick="addRow2()" class="px-3 py-1 border rounded mt-2">＋ Add Item</button>
    </div>
    <div class="mt-4 flex justify-end gap-6 text-lg">
      <div>Sub‑total: <b id="sub2">0</b></div>
      <div>GST %: <input name="gst_percent" id="gst2" type="number" class="w-20 border rounded p-1" value="0"></div>
      <div>Grand: <b id="grand2">0</b></div>
    </div>
  </form>
</div>
<script>
const prods2 = <?=json_encode($prods)?>;
function addRow2(){
  const tr=document.createElement('tr');
  tr.innerHTML=`<td class="p-1"><select class="border rounded p-1 w-full" onchange="sync2(this)">
    <option value="">-- choose --</option>
    ${prods2.map(p=>`<option data-id="${p.id}" value="${p.name}">${p.name}</option>`).join('')}
  </select></td>
  <td class="p-1"><input type="number" class="border rounded p-1 w-24" value="0" oninput="re2()"></td>
  <td class="p-1"><input type="number" class="border rounded p-1 w-20" value="1" oninput="re2()"></td>
  <td class="p-1 text-right"><span class="line2">0</span></td>
  <td class="p-1"><button type="button" class="px-2 py-1 border rounded" onclick="this.closest('tr').remove(); re2();">✖</button></td>`;
  rows2.appendChild(tr);
}
function sync2(sel){ re2(); }
function re2(){
  let sub=0; document.querySelectorAll('#rows2 tr').forEach(tr=>{
    const price=+tr.children[1].querySelector('input').value||0; const qty=+tr.children[2].querySelector('input').value||0; const line=price*qty; sub+=line; tr.querySelector('.line2').textContent=Math.round(line);
  });
  const gst=+document.getElementById('gst2').value||0; const grand=Math.round(sub*(1+gst/100));
  document.getElementById('sub2').textContent=Math.round(sub); document.getElementById('grand2').textContent=grand;
}
addRow2();
</script>
