<?php
require_once __DIR__.'/../config/config.php';
require_once __DIR__.'/../lib/db.php';
$id=(int)($_GET['id']??0);
$inv = $pdo->prepare('SELECT * FROM sales WHERE id=?'); $inv->execute([$id]); $inv=$inv->fetch();
if(!$inv) die('Invoice not found');
$rows = $pdo->prepare('SELECT * FROM sale_items WHERE sale_id=?'); $rows->execute([$id]); $rows=$rows->fetchAll();

// HTML template
ob_start(); ?>
<!DOCTYPE html><html><head><meta charset="utf-8"><style>
body{font-family:DejaVu Sans, Arial, sans-serif;}
table{border-collapse:collapse;width:100%;}
th,td{border:1px solid #ddd;padding:6px;font-size:12px;}
</style></head><body>
<div style="display:flex;justify-content:space-between;align-items:flex-start">
  <div>
    <div style="font-weight:800;font-size:20px">SherPay</div>
    <div style="font-size:12px">Address here</div>
    <div style="font-size:12px">Phone here</div>
  </div>
  <div style="text-align:right">
    <div style="font-weight:700;font-size:18px">INVOICE</div>
    <div>#<?=htmlspecialchars($inv['invoice_no'])?></div>
    <div><?=date('d M Y', strtotime($inv['sale_date']))?></div>
  </div>
</div>
<hr/>
<div style="display:grid;grid-template-columns:1fr 1fr;gap:8px;font-size:12px">
  <div><b>Customer:</b> <?=htmlspecialchars($inv['customer_name']?:'Walk‑in')?> (<?=htmlspecialchars($inv['mobile']?:'')?>)</div>
  <div><b>Notes:</b> <?=htmlspecialchars($inv['notes']?:'')?>
</div></div>
<table style="margin-top:10px">
  <thead><tr><th>#</th><th>Product</th><th style="text-align:right">Price</th><th style="text-align:right">Qty</th><th style="text-align:right">Total</th></tr></thead>
  <tbody>
  <?php foreach($rows as $i=>$r): ?>
    <tr><td><?=$i+1?></td><td><?=htmlspecialchars($r['item_name'])?></td><td style="text-align:right"><?=$r['price']?></td><td style="text-align:right"><?=$r['qty']?></td><td style="text-align:right"><?=round($r['line_total'])?></td></tr>
  <?php endforeach; ?>
  </tbody>
</table>
<div style="text-align:right;margin-top:10px">
  <div>Sub‑total: <b><?=round($inv['sub_total'])?></b></div>
  <div>GST: <b><?=$inv['gst_percent']?>%</b></div>
  <div style="font-size:18px">Grand: <b><?=round($inv['grand_total'])?></b></div>
</div>
</body></html>
<?php $html = ob_get_clean();

// If Dompdf installed (composer), render PDF; else just echo HTML
$vendor = __DIR__.'/../vendor/autoload.php';
if (file_exists($vendor)){
  require_once $vendor;
  $dompdf = new Dompdf\Dompdf([ 'isHtml5ParserEnabled'=>true, 'isRemoteEnabled'=>true ]);
  $dompdf->loadHtml($html);
  $dompdf->setPaper('A4');
  $dompdf->render();
  $dompdf->stream($inv['invoice_no'].'.pdf');
} else {
  echo $html; // browser print
}
