<?php
// KPIs
$today = date('Y-m-d');
$month = date('Y-m');
$today_total = $pdo->prepare("SELECT COALESCE(SUM(grand_total),0) t FROM sales WHERE sale_date=?");
$today_total->execute([$today]); $today_total = $today_total->fetch()['t'];
$month_total = $pdo->prepare("SELECT COALESCE(SUM(grand_total),0) t FROM sales WHERE DATE_FORMAT(sale_date,'%Y-%m')=?");
$month_total->execute([$month]); $month_total = $month_total->fetch()['t'];
$products_count = $pdo->query("SELECT COUNT(*) c FROM products")->fetch()['c'];
$low_stock = $pdo->query("SELECT COUNT(*) c FROM products WHERE stock<=low_stock")->fetch()['c'];
?>
<div class="grid md:grid-cols-4 gap-4">
  <div class="bg-white rounded-xl shadow p-4"><div class="text-sm text-gray-500"><?=__('today_sales')?></div><div class="text-2xl font-extrabold"><?=money($today_total)?></div></div>
  <div class="bg-white rounded-xl shadow p-4"><div class="text-sm text-gray-500"><?=__('month_sales')?></div><div class="text-2xl font-extrabold"><?=money($month_total)?></div></div>
  <div class="bg-white rounded-xl shadow p-4"><div class="text-sm text-gray-500"><?=__('products_count')?></div><div class="text-2xl font-extrabold"><?=$products_count?></div></div>
  <div class="bg-white rounded-xl shadow p-4"><div class="text-sm text-gray-500"><?=__('low_stock')?></div><div class="text-2xl font-extrabold"><?=$low_stock?></div></div>
</div>

<?php
// 14-day sales series
$stmt = $pdo->prepare("SELECT sale_date, SUM(grand_total) t FROM sales WHERE sale_date>=DATE_SUB(CURDATE(), INTERVAL 13 DAY) GROUP BY sale_date ORDER BY sale_date");
$stmt->execute(); $rows = $stmt->fetchAll();
$map=[]; for($i=13;$i>=0;$i--){ $d=date('Y-m-d',strtotime("-$i day")); $map[$d]=0; }
foreach($rows as $r){ $map[$r['sale_date']] = (float)$r['t']; }
$labels = array_keys($map); $values = array_values($map);
?>
<div class="bg-white rounded-xl shadow p-4 mt-4">
  <div class="font-semibold mb-2"><?=__('sales_14d')?></div>
  <canvas id="chartSales" height="100"></canvas>
</div>
<script>
const ctx = document.getElementById('chartSales').getContext('2d');
new Chart(ctx, { type:'line', data:{ labels: <?=json_encode(array_map(fn($d)=>date('d M',strtotime($d)),$labels))?>, datasets:[{ label:'Sales', data: <?=json_encode($values)?> }] }, options:{ responsive:true, maintainAspectRatio:false }});
</script>
