<?php // public/login.php
require_once __DIR__.'/../config/config.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../config/i18n.php';

if (isset($_GET['lang'])) { $_SESSION['lang']=$_GET['lang']; }

$error = '';
if ($_SERVER['REQUEST_METHOD']==='POST'){
  if (login($_POST['email']??'', $_POST['password']??'')){
    header('Location: '.BASE_PATH.'/index.php'); exit;
  } else $error = 'Invalid login';
}
?>
<!DOCTYPE html><html><head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width,initial-scale=1"/>
<title><?=APP_NAME?> — Login</title>
<link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head><body class="bg-gray-50">
<div class="min-h-screen flex items-center justify-center p-4">
  <div class="bg-white rounded-xl shadow p-6 w-full max-w-md">
    <h1 class="text-xl font-bold mb-2"><?=__('login')?></h1>
    <?php if($error): ?><div class="text-red-600 text-sm mb-2"><?=$error?></div><?php endif; ?>
    <form method="post" class="space-y-3">
      <div>
        <label class="text-sm font-medium block mb-1"><?=__('email')?></label>
        <input name="email" class="border rounded w-full p-2" placeholder="admin@local" />
      </div>
      <div>
        <label class="text-sm font-medium block mb-1"><?=__('password')?></label>
        <input name="password" type="password" class="border rounded w-full p-2" placeholder="123456" />
      </div>
      <button class="px-3 py-2 rounded-lg font-semibold text-white" style="background:#0ea5b7"><?=__('sign_in')?></button>
    </form>
    <div class="text-xs text-gray-500 mt-3">
      Admin: admin@local / 123456
    </div>
    <div class="mt-3 flex gap-2 text-xs">
      <a class="px-2 py-1 border rounded" href="?lang=ur">اردو</a>
      <a class="px-2 py-1 border rounded" href="?lang=en">EN</a>
    </div>
  </div>
</div>
</body></html>
