<?php
$invoices = $pdo->query('SELECT * FROM sales ORDER BY id DESC LIMIT 200')->fetchAll();
?>
<div class="bg-white rounded-xl shadow p-4">
  <div class="font-semibold mb-3">Invoices</div>
  <div class="grid lg:grid-cols-2 gap-3">
    <?php foreach($invoices as $inv): ?>
    <div class="border rounded-xl p-3 flex items-center justify-between">
      <div>
        <div class="font-semibold">#<?=htmlspecialchars($inv['invoice_no'])?> • <?=date('M d, Y', strtotime($inv['sale_date']))?></div>
        <div class="text-sm text-gray-500"><?=htmlspecialchars($inv['customer_name']?:'Walk‑in')?> — <?=money($inv['grand_total'])?></div>
      </div>
      <div class="flex gap-2">
        <a class="px-2 py-1 border rounded" href="<?=BASE_PATH?>/pages/invoice_print.php?id=<?=$inv['id']?>" target="_blank">🖨️ Print</a>
      </div>
    </div>
    <?php endforeach; ?>
  </div>
</div>
