<?php // partials/header.php
require_once __DIR__.'/../config/config.php';
require_once __DIR__.'/../config/i18n.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title><?=APP_NAME?></title>
<link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="bg-gray-50">
<header class="bg-white border-b sticky top-0 z-20">
  <div class="max-w-7xl mx-auto px-4 py-3 flex items-center justify-between">
    <div class="flex items-center gap-3">
      <div class="w-10 h-10 rounded-xl flex items-center justify-center text-white font-extrabold text-lg" style="background:linear-gradient(135deg,#0ea5b7,#14b8a6)">S</div>
      <div class="text-xl font-extrabold">SherPay</div>
    </div>
    <div class="flex items-center gap-2">
      <a href="?lang=ur" class="px-2 py-1 border rounded">اردو</a>
      <a href="?lang=en" class="px-2 py-1 border rounded">EN</a>
      <?php if(isset($_SESSION['user'])): ?>
      <a href="<?=BASE_PATH?>/logout.php" class="px-3 py-2 border rounded"><?=__('logout')?></a>
      <?php endif; ?>
    </div>
  </div>
</header>
<div class="max-w-7xl mx-auto px-4 py-6 grid md:grid-cols-12 gap-4">
