<?php
// Create / Update
if ($_SERVER['REQUEST_METHOD']==='POST'){
  $id = (int)($_POST['id']??0);
  $sku = trim($_POST['sku']??'');
  $name = trim($_POST['name']??'');
  $price = (float)($_POST['price']??0);
  $stock = (int)($_POST['stock']??0);
  $low = (int)($_POST['low_stock']??5);
  if($id>0){
    $stmt=$pdo->prepare('UPDATE products SET sku=?, name=?, price=?, stock=?, low_stock=? WHERE id=?');
    $stmt->execute([$sku,$name,$price,$stock,$low,$id]);
  } else {
    $stmt=$pdo->prepare('INSERT INTO products(sku,name,price,stock,low_stock) VALUES(?,?,?,?,?)');
    $stmt->execute([$sku,$name,$price,$stock,$low]);
  }
  header('Location: '.BASE_PATH.'/index.php?p=products'); exit;
}

// Delete
if (isset($_GET['del'])){
  $id=(int)$_GET['del'];
  $pdo->prepare('DELETE FROM products WHERE id=?')->execute([$id]);
  header('Location: '.BASE_PATH.'/index.php?p=products'); exit;
}

$products = $pdo->query('SELECT * FROM products ORDER BY id DESC')->fetchAll();
?>
<div class="bg-white rounded-xl shadow p-4">
  <div class="flex items-center justify-between mb-3">
    <div class="font-semibold"><?=__('products')?></div>
    <div class="flex gap-2">
      <form action="<?=BASE_PATH?>/index.php?p=import_products" method="post" enctype="multipart/form-data">
        <label class="px-3 py-2 border rounded cursor-pointer">⬆️ CSV <input type="file" name="csv" class="hidden" accept=".csv" onchange="this.form.submit()"></label>
      </form>
      <button onclick="document.getElementById('prodForm').reset();document.getElementById('modal').showModal();" class="px-3 py-2 rounded text-white" style="background:#0ea5b7">＋ Add</button>
    </div>
  </div>
  <div class="overflow-x-auto">
    <table class="w-full text-sm">
      <thead><tr class="text-left text-gray-500"><th class="p-2">ID</th><th class="p-2">SKU</th><th class="p-2">Name</th><th class="p-2">Price</th><th class="p-2">Stock</th><th class="p-2">Low</th><th class="p-2">Actions</th></tr></thead>
      <tbody>
        <?php foreach($products as $p): ?>
        <tr>
          <td class="p-2"><?=$p['id']?></td>
          <td class="p-2"><?=htmlspecialchars($p['sku'])?></td>
          <td class="p-2"><?=htmlspecialchars($p['name'])?></td>
          <td class="p-2"><?=money($p['price'])?></td>
          <td class="p-2"><?=$p['stock']?></td>
          <td class="p-2"><?=$p['low_stock']?></td>
          <td class="p-2">
            <button class="px-2 py-1 border rounded" onclick='fillEdit(<?=json_encode($p)?>)'>Edit</button>
            <a class="px-2 py-1 border rounded" href="<?=BASE_PATH?>/index.php?p=products&del=<?=$p['id']?>" onclick="return confirm('Delete?')">Del</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<dialog id="modal" class="p-0 rounded-xl">
  <form id="prodForm" method="post" class="p-4 min-w-[320px]">
    <input type="hidden" name="id" id="f_id" />
    <div class="grid md:grid-cols-2 gap-3">
      <div><label class="text-sm">SKU</label><input name="sku" id="f_sku" class="border rounded w-full p-2"></div>
      <div><label class="text-sm">Name</label><input name="name" id="f_name" class="border rounded w-full p-2" required></div>
      <div><label class="text-sm">Price</label><input name="price" id="f_price" type="number" step="0.01" class="border rounded w-full p-2"></div>
      <div><label class="text-sm">Stock</label><input name="stock" id="f_stock" type="number" class="border rounded w-full p-2"></div>
      <div><label class="text-sm">Low Stock</label><input name="low_stock" id="f_low" type="number" class="border rounded w-full p-2" value="5"></div>
    </div>
    <div class="mt-3 flex justify-end gap-2">
      <button type="button" class="px-3 py-2 border rounded" onclick="document.getElementById('modal').close()">Cancel</button>
      <button class="px-3 py-2 rounded text-white" style="background:#0ea5b7">Save</button>
    </div>
  </form>
</dialog>
<script>
function fillEdit(p){
  f_id.value=p.id; f_sku.value=p.sku||''; f_name.value=p.name||''; f_price.value=p.price||0; f_stock.value=p.stock||0; f_low.value=p.low_stock||5; modal.showModal();
}
</script>
